/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import oracle.i18n.util.LocaleMapper;

public class OraInternetAddress
extends InternetAddress {
    public OraInternetAddress(String string, String string2, Locale locale) throws AddressException {
        super(string);
        try {
            this.setPersonal(string2, locale);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public OraInternetAddress(String string, String string2, String string3) throws AddressException, UnsupportedEncodingException {
        super(string);
        super.setPersonal(string2, OraInternetAddress.getSafeCharacterSet(string2, string3));
    }

    public void setPersonal(String string, Locale locale) throws UnsupportedEncodingException {
        if (!OraInternetAddress.isNonAsciiContained(string)) {
            super.setPersonal(string);
            return;
        }
        String[] stringArray = LocaleMapper.getIANACharSetFromLocale(4, locale);
        if (stringArray != null && stringArray.length > 0) {
            this.setPersonal(string, OraInternetAddress.getSafeCharacterSet(string, stringArray[0]));
        } else {
            super.setPersonal(string);
        }
    }

    static boolean isNonAsciiContained(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if ((string.charAt(i) & 0xFF80) == 0) continue;
            return true;
        }
        return false;
    }

    static String getSafeCharacterSet(String string, String string2) {
        try {
            String string3 = new String(string.getBytes(string2));
            return string3.equals(string) ? string2 : "utf-8";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "utf-8";
        }
    }
}

